//============================Yahboom========================================
//  Bat car Comprehensive Experiment
//=============================================================================
#include "./IRremote.h"

//IR control
int RECV_PIN = 2; // Set Infrared Remote port
IRrecv irrecv(RECV_PIN);
decode_results results; // Store infrared remote decode data
unsigned long last = millis();

#define run_car     '1'
#define back_car    '2'
#define left_car    '3'
#define right_car   '4'
#define stop_car    '0'
/*Car running status enumeration*/
enum {
  enSTOP = 0,
  enRUN,
  enBACK,
  enLEFT,
  enRIGHT,
  enTLEFT,
  enTRIGHT
} enCarState;

//==============================
//
//Speed control
int control = 150;          //PWM control speed
#define level1  0x08
#define level2  0x09
#define level3  0x0A
#define level4  0x0B
#define level5  0x0C
#define level6  0x0D
#define level7  0x0E
#define level8  0x0F
//==============================
//==============================
int Left_motor_back = 9;     
int Left_motor_go = 5;       
int Right_motor_go = 6;      
int Right_motor_back = 10;   
int Right_motor_en = 8;      
int Left_motor_en = 7;      

//Bluetooth protocol related
int incomingByte = 0;       // Store Received Data(byte)
String inputString = "";         // Store Received Data(String)
boolean newLineReceived = false; // Previous data end flag
boolean startBit  = false;  //Protocol start flag
String returntemp = ""; //Store return data

/*Set BUZZER port*/
int BUZZER = 3;            
/*Set LED port*/
int LED = 13;
/*Set Button port*/
int KEY = 4;

/*Ultrasonic Sensor*/
int Echo = A1;  //  Set Echo port
int Trig = A0; // Set Trig port
int Distance = 0;
/*Line Walking*/
const int SensorRight = A3;   	//Set Right Line Walking Infrared sensor port
const int SensorLeft = A2;     	//Set Left Line Walking Infrared sensor port
int SL;    //State of Left Line Walking Infrared sensor
int SR;    //State of Right Line Walking Infrared sensor
/*Tracking*/
const int SensorRight_2 = A4;     //Right Tracking Infrared sensor
const int SensorLeft_2 = A5;      //Left Tracking Infrared sensor
int SL_2;    //State of Left Tracking Infrared sensor
int SR_2;    //State of Right Tracking Infrared sensor

//State
int g_carstate = enSTOP; //1:front 2:back 3:left 4:right 0:stop // State of vehicle running state
int g_modeSelect = 0;  //0:remote control mode(default); 1:line walking mode ; 2: obsracle avoidance mode; 3: tracking
int g_modeComunication = 0; // 0:Infrared remote control 1:Bluetooth remote control
int g_AllState = 0;  // 0: Busying; 1:Mode selection 
int g_IRRealse = 0;

int serial_putc( char c, struct __file * )
{
  Serial.write( c );
  return c;
}
void printf_begin(void)
{
  fdevopen( &serial_putc, 0 );
}

void setup()
{
  //Initialize motor drive for output mode
  pinMode(Left_motor_go, OUTPUT);    // PIN 5 (PWM)
  pinMode(Left_motor_back, OUTPUT);  // PIN 9 (PWM)
  pinMode(Right_motor_go, OUTPUT);   // PIN 6 (PWM)
  pinMode(Right_motor_back, OUTPUT); // PIN 10 (PWM)
  pinMode(Right_motor_en, OUTPUT);   // PIN 8
  pinMode(Left_motor_en, OUTPUT);    // PIN 7

  pinMode(BUZZER, OUTPUT);
  pinMode(LED, OUTPUT);
  pinMode(KEY, INPUT_PULLUP);     

  pinMode(Echo, INPUT);    
  pinMode(Trig, OUTPUT);  

  pinMode(SensorRight, INPUT); 
  pinMode(SensorLeft, INPUT); 

  Serial.begin(9600);

  digitalWrite(BUZZER, HIGH);  
  digitalWrite(Left_motor_en, HIGH);
  digitalWrite(Right_motor_en, HIGH); 

  g_carstate = enSTOP; 
  g_modeComunication = 0; 
  g_modeSelect = 0;   
  irrecv.enableIRIn();
  pinMode(RECV_PIN, INPUT_PULLUP);     

  printf_begin();
}

void Distance_test()   
{
  digitalWrite(Trig, LOW);   
  delayMicroseconds(2);
  digitalWrite(Trig, HIGH); 
  delayMicroseconds(10);
  digitalWrite(Trig, LOW);  
  float Fdistance = pulseIn(Echo, HIGH); 
  Fdistance = Fdistance / 58;   
  Distance = Fdistance;
}

void run()     
{
  digitalWrite(Right_motor_go, HIGH);
  digitalWrite(Right_motor_back, LOW);
  analogWrite(Right_motor_go, control); 

  digitalWrite(Left_motor_go, HIGH); 
  digitalWrite(Left_motor_back, LOW);
  analogWrite(Left_motor_go, control);

}

void brake()         
{
  digitalWrite(Left_motor_back, LOW);
  digitalWrite(Left_motor_go, LOW);
  digitalWrite(Right_motor_go, LOW);
  digitalWrite(Right_motor_back, LOW);
}

void left()        
{
  digitalWrite(Right_motor_go, HIGH);	
  digitalWrite(Right_motor_back, LOW);
  analogWrite(Right_motor_go, 180);

  digitalWrite(Left_motor_go, LOW);  
  digitalWrite(Left_motor_back, LOW);
}

void spin_left()         
{
  digitalWrite(Right_motor_go, HIGH);	
  digitalWrite(Right_motor_back, LOW);
  analogWrite(Right_motor_go, control);

  digitalWrite(Left_motor_go, LOW);  
  digitalWrite(Left_motor_back, HIGH);
  analogWrite(Left_motor_back, control); 

}

void right()        
{
  digitalWrite(Right_motor_go, LOW);  
  digitalWrite(Right_motor_back, LOW);

  digitalWrite(Left_motor_go, HIGH);
  digitalWrite(Left_motor_back, LOW);
  analogWrite(Left_motor_go, 180); //control);
}

void spin_right()       
{
  digitalWrite(Right_motor_go, LOW);  
  digitalWrite(Right_motor_back, HIGH);
  analogWrite(Right_motor_back, control); 

  digitalWrite(Left_motor_go, HIGH); 
  digitalWrite(Left_motor_back, LOW);
  analogWrite(Left_motor_go, control); 

}

void back()        
{
  digitalWrite(Right_motor_go, LOW); 
  digitalWrite(Right_motor_back, HIGH);
  analogWrite(Right_motor_back, control); 

  digitalWrite(Left_motor_go, LOW); 
  digitalWrite(Left_motor_back, HIGH);
  analogWrite(Left_motor_back, control); 

}
void whistle()   
{
  int i;
  for (i = 0; i < 15; i++) //Output one frequency sound
  {
    digitalWrite(BUZZER, LOW); //sounds
    delay(10);// delay 10ms
    digitalWrite(BUZZER, HIGH); //mute
    delay(1);// delay 1ms
  }
}

/*Bluetooth receive*/
void Bluetooth(void)
{
  if (newLineReceived)
  {
    //Determine if mode selection or not
    if (inputString[1] == 'M' && inputString[2] == 'O' && inputString[3] == 'D' && inputString[4] == 'E')
    {
      if (inputString[6] == '0') //stop mode
      {
        g_carstate = enSTOP;
        g_modeSelect = 0;
        g_AllState = 0;
        BeepOnOffMode();
      }
      else
      {
        switch (inputString[5])
        {
          case '0': g_modeSelect = 0; break;
          case '1': g_modeSelect = 1; break;
          case '2': g_modeSelect = 2; break;
          case '3': g_modeSelect = 3; break;
          default: g_modeSelect = 0; break;
        }
        g_AllState = 0;
         BeepOnOffMode();
      }
    }
    else if (g_modeSelect == 0 && g_AllState == 0) //remote control mode(default)
    {
      switch (inputString[1])
      {
        case run_car:   g_carstate = enRUN; Serial.print("run\r\n"); break;
        case back_car:  g_carstate = enBACK;  Serial.print("back\r\n"); break;
        case left_car:  g_carstate = enLEFT; Serial.print("left\r\n"); break;
        case right_car: g_carstate = enRIGHT; Serial.print("right\r\n"); break;
        case stop_car:  g_carstate = enSTOP; Serial.print("brake\r\n"); break;
        default: g_carstate = enSTOP; break;
      }
      if (inputString[3] == '1') //Left rotation
      {
        spin_left();
        Serial.print("revolve\r\n");
        delay(2000);
        brake();
      }
      else if (inputString[3] == '2') //Right rotation
      {
        spin_right();
        Serial.print("revolve\r\n");
        delay(2000);
        brake();
      }
      if (inputString[5] == '1') //whistle
      {
        whistle();
        Serial.print("whistle\r\n");
      }
      if (inputString[7] == '1') //speed up
      {
        control += 50;
        if (control > 255)
        {
          control = 255;
        }
        Serial.print("expedite\r\n");
      }
      if (inputString[9] == '1') //speed reduction
      {
        control -= 50;
        if (control < 50)
        {
          control = 100;
        }
        Serial.print("reduce\r\n");
      }

      //Return ultrasonic data
      Distance_test();
      returntemp = "$0,0,0,0,0,0,0,0,0,0,0,";
      returntemp.concat(Distance);
      returntemp += "cm,8.2V#";
      Serial.print(returntemp); 

    }
    inputString = "";   // clear the string
    newLineReceived = false;

  }
}

void Key_Scan(void)
{
  int val;
  while (!digitalRead(KEY))
  {
    delay(10);	
    val = digitalRead(KEY);
    if (val == LOW) 
    {
      if (g_modeComunication == 0)
      {
        g_modeComunication = 1; 
        digitalWrite(LED, HIGH); 
      }
      else
      {
        g_modeComunication = 0; 
        digitalWrite(LED, LOW); 
      }
      digitalWrite(BUZZER, LOW);		
      delay(100);//100ms
      digitalWrite(BUZZER, HIGH);		
      while (!digitalRead(KEY));	
    }
    else
      digitalWrite(BUZZER, HIGH);
  }
}

//Car running control
void CarControl()
{
  if (g_modeSelect != 2 )
  {
    switch (g_carstate)
    {
      case enSTOP: brake(); break;
      case enRUN: run(); break;
      case enLEFT: left(); break;
      case enRIGHT: right(); break;
      case enBACK: back(); break;
      case enTLEFT: spin_left(); break;
      case enTRIGHT: spin_right(); break;
      default: brake(); break;
    }
   
  }
}

void IR_Deal()
{
  if (irrecv.decode(&results)) 
  {
    switch (results.value)
    {
      case 0x00FFA25D: g_carstate = enSTOP; g_AllState = 0; g_modeSelect = 0; BeepOnOffMode() ;break;
      case 0x00FFA857: g_carstate = enSTOP; g_AllState = 0; BeepOnOffMode() ; break; // PLAY
      //case 0x00FFE01F: g_AllState = 1; g_modeSelect--; if (g_modeSelect == -1) g_modeSelect = 3; break;
      //case 0x00FF906F: g_AllState = 1; g_modeSelect++; if (g_modeSelect == 4) g_modeSelect = 0;  break;
      case 0x00FFE21D: g_AllState = 1; g_modeSelect = 0;  ModeBEEP(g_modeSelect); break; 
      case 0x00FFC23D: g_AllState = 1; g_modeSelect = 2;  ModeBEEP(g_modeSelect); break; 
      case 0x00FF906F: g_AllState = 1; g_modeSelect = 1;  ModeBEEP(g_modeSelect); break; 
      case 0x00FFB04F: g_AllState = 1; g_modeSelect = 3;  ModeBEEP(g_modeSelect); break; 

      default: break;
    }
    if (g_modeSelect == 0 && g_AllState == 0)
    {
      switch (results.value)
      {
        
        case 0x00FF02FD: control += 50; if (control > 255) control = 255; break;
        case 0x00FF9867: control -= 50; if (control < 50) control = 100; break;

        case 0x00FF22DD: whistle(); break;
        case 0x00FF18E7:  g_carstate = enRUN; break;
        case 0x00FF10EF:  g_carstate = enLEFT; break;
        case 0x00FF38C7:  g_carstate = enSTOP; break;
        case 0x00FF5AA5:  g_carstate = enRIGHT; break;
        case 0x00FF4AB5:  g_carstate = enBACK; break;
        case 0x00FF42BD:  g_carstate = enTLEFT; break;
        case 0x00FF52AD:  g_carstate = enTRIGHT; break;
        default: break;

      }
     
    }

    //}
    last = millis();
    irrecv.resume();// received next Infrared decode
  }
  else if (millis() - last > 120)
  {
    g_carstate = enSTOP;
    last = millis();
  }

}
//Mode display
void ModeBEEP(int mode)
{
  for (int i = 0; i < mode + 1; i++)
  {
    digitalWrite(BUZZER, LOW);
    delay(100);
    digitalWrite(BUZZER, HIGH); 
    delay(100);
  }
  delay(100);
  digitalWrite(BUZZER, HIGH); 
}
//buzzer sounds for 1s to wait mode selection
void BeepOnOffMode()
{
  digitalWrite(BUZZER, LOW); 
  delay(1000);
  digitalWrite(BUZZER, HIGH); 
}

//line walking mode
void track()
{
    /**************************************************************************************
  Infrared signal back means white undersurface ,returns low level and led lights up.
  Infrared signal gone means black undersurface ,returns high level and led lights off. 
  **************************************************************************************/
  SR = digitalRead(SensorRight);//Right Line Walking Infrared sensor against white undersurface,then LED[L2] light illuminates and while against black undersurface,LED[L2] goes off
  SL = digitalRead(SensorLeft);//Left Line Walking Infrared sensor against white undersurface,then LED[L3] light illuminates and while against black undersurface,LED[L3] goes off

  if (SL == LOW && SR == LOW) // Black lines were not detected at the same time
    g_carstate = enRUN;   
  else if (SL == LOW & SR == HIGH)// Left sensor against white undersurface and right against black undersurface , the car left off track and need to adjust to the right.
    g_carstate = enRIGHT;
  else if (SR == LOW & SL ==  HIGH) //  Rihgt sensor against white undersurface and left against black undersurface , the car right off track and need to adjust to the left.
    g_carstate = enLEFT;
  else // Black lines were detected at the same time , the car stop.
    g_carstate = enSTOP;
}
//Ultrasonic avoidance
void ultrason_obstacle_avoiding()
{
  Distance_test();

  if (Distance < 25) 
  {
    delay(10);
    Distance_test();
    while (Distance < 25)
    {

      spin_right();
      delay(300);
      brake();
      Distance_test();
    }
  }
  else
    run();
}
//tracking
void Infrared_follow()
{
  /**************************************************************************************
  Infrared signal back means there is something obstacled ,returns low level and led lights up.
  Infrared signal gone means there is nothing obstacled ,returns high level and led lights off.
  **************************************************************************************/
  SR_2 = digitalRead(SensorRight_2);
  SL_2 = digitalRead(SensorLeft_2);
  if (SL_2 == LOW && SR_2 == LOW)
    g_carstate = enRUN;  
  else if (SL_2 == HIGH & SR_2 == LOW)
    g_carstate = enRIGHT;
  else if (SR_2 == HIGH & SL_2 == LOW) 
    g_carstate = enLEFT;
  else 
    g_carstate = enSTOP;
}

/*main loop*/
void loop()
{
  /*Check button press*/
  Key_Scan();

  if (g_modeComunication == 0) //Infrared Remote Control mode
  {
    IR_Deal();
  }
  else //Bluetooth Remote Control mode
  {
    Bluetooth();
  }

   // Switch different mode
  if (g_AllState == 0) 
  {
    switch (g_modeSelect)
    {
      case 1: track(); break; 
      case 2: ultrason_obstacle_avoiding(); break;
      case 3: Infrared_follow(); break;
    }
  }
  CarControl();


}


void serialEvent()
{
  while (Serial.available())
  {
    incomingByte = Serial.read();              
    if (incomingByte == '$')
    {
      startBit = true;
    }
    if (startBit == true)
    {
      inputString += (char) incomingByte;     
    }
    if (incomingByte == '#')
    {
      newLineReceived = true;
      startBit = false;
    }
  }
}



